/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component2;

import com.technicalitiesmc.scm.api2.logical.LogicalComponent;
import com.technicalitiesmc.scm.api2.logical.SideEffects;
import com.technicalitiesmc.scm.api2.logical.StateLike;
import com.technicalitiesmc.scm.api2.signal.InputPort;
import com.technicalitiesmc.scm.api2.signal.OutputPort;
import com.technicalitiesmc.scm.api2.signal.PortBuilder;
import com.technicalitiesmc.scm.api2.signal.SignalMap;
import com.technicalitiesmc.scm.api2.signal.SignalType;
import com.technicalitiesmc.scm.component2.LogicalWireComponent;

public final class LogicalTorchComponent
implements LogicalComponent<State> {
    private final InputPort<Integer> input;
    private final OutputPort<Integer> output;

    public LogicalTorchComponent(PortBuilder<LogicalWireComponent.State> ports) {
        this.input = ports.addInput("in", SignalType.redstone());
        this.output = ports.addOutput("out", SignalType.redstone(), LogicalWireComponent.State::signal);
    }

    public InputPort<Integer> input() {
        return this.input;
    }

    public OutputPort<Integer> output() {
        return this.output;
    }

    @Override
    public StateLike<State> create() {
        return new State(true);
    }

    @Override
    public StateLike<State> onNewInputs(State state, SignalMap signals) {
        return SideEffects.scheduleTick(state, 1);
    }

    @Override
    public StateLike<State> tick(State state, SignalMap signals) {
        return new State(signals.get(this.input) == 0);
    }

    public record State(boolean output) implements LogicalComponent.State<State>
    {
        private int outputValue() {
            return this.output() ? 255 : 0;
        }
    }
}

